
#ifndef SST_TST_ATP_MM_H
#define SST_TST_ATP_MM_H

#if TST_USE_SST_MM_MODULE

/*
* All the includes that are needed for code using this module to
* compile correctly should be #included here.
*/

#ifdef __cplusplus
extern "C"
{
#endif

  /*
  *  Object %name    : %
  *  State           :  %state%
  *  Creation date   :  August 6, 2008
  *  Last modified   :  %modify_time%
  */
  /** @file
  *  \brief A brief description of this module
  *
  *  \version SST_TST_ATP_MM.h.h#1:incl:1
  *  \author Sagit Ben Tsur
  *  \remarks Copyright (C) 2008 by Discretix Technologies Ltd.
  *           All Rights reserved
  */

  /************************ Defines *******************************/
  /************************ Enums *********************************/
  /************************ Typedefs  *****************************/
  /************************ Structs  ******************************/
  /*Authenticator test struct*/

  /************************ Public Variables **********************/
  /************************ Public Functions **********************/
  /****************************************************************
  * Function Name:                                                           
  *  SST_TST_ATP_MM
  * 
  * Inputs:
  *  None
  *
  * Outputs:
  *  DxError_t - Function error return
  *
  * Description:
  *    Test the mode management set and get APIs and authenticator with mode
  * 
  * Algorithm:
  *    1. USER - Board: cold boot, PC: exit the ATP application.
  *    2. USER - Start the ATP application and choose the mode management 0peration test.
  *    3. Call SST_Init.
  *    4. Call SST_MMGet and verify the SST is in privilege mode.
  *    5. Call SST_SessionCreate.
  *    6. Call SST_TransactionStart 
  *    7. Call SST_MMPriAuthCreate to Create a privileged mode authenticator
  *    8. Call SST_AuthenticatorAESSharedSecretCreate.
  *    9. Call SST_MMAuthSet and set to Privileged.
  *    10. Call SST_DataInsert with the priv-authenticator as initial control authenticator.
  *    11  Call SST_AuthenticatorBind with the data and aes-authenticator.
  *    12. Call SST_MMPriAuthOpento open the priv-authenticator on the session.
  *    13. Call SST_DataRead and verify the data is correct.
  *    14. Call SST_AuthenticationClose (priv).
  *    15. Call SST_DataRead  FAIL
  *    16. Call SST_AuthenticatorChallengeGet
  *    17. Call CRYS_AES and Encrypt the data with the key fro the AES authenticator
  *    18. Call SST_AuthenticationOpen
  *    19. Call SST_DataRead  success
  *    20. Call SST_MMSystemSet and set the system to user mode.
  *    21. Call SST_AuthenticationOpen to the priv-authenticator, verify the operation failed.
  *    22. Call SST_AuthenticationOpen to the aes-authenticator, verify the operation failed.
  *    23. Call SST_TransactionEnd.
  *    24. Call SST_SessionDelete.
  *    25. Call SST_Terminate.
  *    26. Call SST_Init
  *    27. #ifndef DX_CC5_SEP_PLAT
  *       i.  Call SST_MMSet with user mode
  *    28. #endif // PC
  *    29. Call SST_MMGet and verify the SST is in user mode.
  *******************************************************************************/
  DxError_t SST_TST_ATP_MM ( void );



#ifdef __cplusplus
}
#endif

#endif

#endif



